﻿<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>KPKW</title>
		<script runat="server">

	static readonly int repeat = 2;
	
    class Body {
        readonly Zaplata zapłata;
        readonly int zł;
        readonly int gr;
        readonly string szł;
        readonly string sgr;
        public Body(Zaplata zapłata) {
            this.zapłata = zapłata;
			decimal xzł = Soneta.Tools.Math.Floor(this.zapłata.Kwota.Value);
			decimal xgr = this.zapłata.Kwota.Value - xzł;
			zł = (int)xzł;
			gr = (int)(100m*xgr);
						
			Waluta w = WalutyModule.GetInstance(zapłata).Waluty[zapłata.Kwota.Symbol];
			if (w==null) {
				szł = "?";
				sgr = "?";
			}
			else {
				szł = w.Calkowity;
				sgr = w.Dziesietny;
			}			
        }
        public string Header1 {
            get { return zapłata.Kierunek==KierunekPlatnosci.Przychod ? "<b>Od kogo</b>" : "<b>Dla</b>"; }
        }
        public string Podmiot1 {
            get { return "<B>" + zapłata.DaneKontrahenta.Nazwa + "</B>"; }
        }
		public string Podmiot2 {
            get { return zapłata.DaneKontrahenta.Adres.Linia1; }
        }
		public string Podmiot3 {
            get { return zapłata.DaneKontrahenta.Adres.Linia2; }
        }
		public string Podmiot4 {
            get { return "NIP: " + zapłata.DaneKontrahenta.NIP; }
        }
        public string Header2 {
            get { return zapłata.Kierunek==KierunekPlatnosci.Przychod ? "<b>Wpłata</b>" : "<b>Wypłata</b>"; }
        }
        public string zł1 {
            get { return szł; }
        }
        public string zł2 {
            get { return "<h5>" + zł.ToString() + "</h5>"; }
        }
        public string gr1 {
            get { return sgr; }
        }
        public string gr2 {
            get { return "<h5>" + gr.ToString("00") + "</h5>"; }
        }
    }
    
	class OpisNumery {
        readonly Zaplata zapłata;
        public OpisNumery(Zaplata zapłata) {
            this.zapłata = zapłata;
	    }
		public string Title {
		    get { return "<b>Opis</b>"; }
		}
		public string Opis {
		    get { return zapłata.Opis; }
		}		
		public string Title2 {
			get { return "."; }
		}
		public string Numery {
		    get { return zapłata.NumeryDokumentow; }
		}		
	}

	class Słownie {
        readonly Zaplata zapłata;
        public Słownie(Zaplata zapłata) {
            this.zapłata = zapłata;
	    }
		public string Title {
		    get { return "<b>Słownie</b>"; }
		}
		public string Value {
		    get { return zapłata.Słownie; }
		}		
	}
	
	class Sposób {
        readonly Zaplata zapłata;
        public Sposób(Zaplata zapłata) {
            this.zapłata = zapłata;
	    }
		public string Title {
		    get { return "<b>Sposób zapłaty</b>"; }
		}
		public SposobZaplaty Value {
		    get { return zapłata.SposobZaplaty; }
		}		
	}
	
    void OnLoad(Object sender, EventArgs args) {
		Section1.Repeat = repeat;
		
		DokumentHandlowy dok = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];
		Zaplata zapłata = dok.Zapłata;
		if (zapłata==null)
			throw new RowException(dok, "Dla dokumentu nie wprowadzono zapłaty. Wydruk KP/KW nie jest możliwy.");
		decimal kw = Soneta.Tools.Math.Floor(zapłata.Kwota.Value);
		decimal gr = zapłata.Kwota.Value - kw;

        ArrayList body = new ArrayList();
        body.Add(new Body(zapłata));
		Grid1.DataSource = body;
    
		ArrayList opis = new ArrayList();
		opis.Add(new OpisNumery(zapłata));
		Grid2.DataSource = opis;
		
		ArrayList słownie = new ArrayList();
		słownie.Add(new Słownie(zapłata));
		Grid3.DataSource = słownie;
		
		if (zapłata.SposobZaplaty.Typ==TypySposobowZaplaty.Gotówka)
			Grid4.Visible = false;
		else
			Grid4.DataSource = new object[] { new Sposób(zapłata) };
		
		ReportHeader1["TYP"] = zapłata.Kierunek==KierunekPlatnosci.Przychod ? "KP" : "KW";
        raport.Caption = "Raport kasowy<br>"+zapłata.Raport.NumerRaportu+"<br>Pozycja " + zapłata.Lp;
    }

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=unicode">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="KPKW2" method="post" runat="server" onload="OnLoad">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"></ea:datacontext><ea:section id="Section1" runat="server" Width="100%">
				<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
				<ea:PageBreak id="PageBreak1" runat="server" Required="False" BreakFirstTimes="False"></ea:PageBreak>
				<TABLE id="Table1" cellSpacing="0" width="70%">
					<TR>
						<TD>
							<cc1:ReportHeader id="ReportHeader1" title="%TYP%|</strong>Kasa:<strong> {0}|</strong>Numer:<strong> {1}|</strong>Data:<strong> {2}"
								runat="server" WithSections="False" DataMember1="Zapłata.NumerDokumentu" DataMember0="Zapłata.EwidencjaSP"
								DataMember2="Zapłata.DataDokumentu"></cc1:ReportHeader>
							<ea:Grid id="Grid1" runat="server" WithSections="False" RowsInRow="5" ShowHeader="None">
								<Columns>
									<ea:GridColumn Width="50" BottomBorder="Single" Align="Center" DataMember="Header1" Caption="A"></ea:GridColumn>
									<ea:GridColumn DataMember="Podmiot1" Caption="B"></ea:GridColumn>
									<ea:GridColumn DataMember="Podmiot2" Caption="C"></ea:GridColumn>
									<ea:GridColumn DataMember="Podmiot3" Caption="D"></ea:GridColumn>
									<ea:GridColumn DataMember="Podmiot4" Caption="E"></ea:GridColumn>
									<ea:GridColumn ColSpan="2" BottomBorder="Single" Align="Center" DataMember="Header2" Caption="F"></ea:GridColumn>
									<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="zł1" Caption="G"></ea:GridColumn>
									<ea:GridColumn Align="Center" DataMember="zł2" Caption="H" RowSpan="3"></ea:GridColumn>
									<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="gr1" Caption="I"></ea:GridColumn>
									<ea:GridColumn Align="Center" DataMember="gr2" Caption="J" RowSpan="3"></ea:GridColumn>
								</Columns>
							</ea:Grid>
							<TABLE height="5">
								<TR>
									<TD></TD>
								</TR>
							</TABLE>
							<ea:Grid id="Grid2" runat="server" WithSections="False" RowsInRow="2" ShowHeader="None">
								<Columns>
									<ea:GridColumn Width="15" DataMember="Title" Caption="A" RowSpan="2"></ea:GridColumn>
									<ea:GridColumn DataMember="Opis" Caption="C"></ea:GridColumn>
									<ea:GridColumn DataMember="Numery" Caption="D"></ea:GridColumn>
								</Columns>
							</ea:Grid>
							<TABLE height="5">
								<TR>
									<TD></TD>
								</TR>
							</TABLE>
							<ea:Grid id="Grid3" runat="server" WithSections="False" ShowHeader="None">
								<Columns>
									<ea:GridColumn Width="15" DataMember="Title" Caption="A"></ea:GridColumn>
									<ea:GridColumn DataMember="Value" Caption="B"></ea:GridColumn>
								</Columns>
							</ea:Grid>
							<TABLE height="5">
								<TR>
									<TD></TD>
								</TR>
							</TABLE>
							<ea:Grid id="Grid4" runat="server" WithSections="False" ShowHeader="None">
								<Columns>
									<ea:GridColumn Width="15" DataMember="Title" Caption="A"></ea:GridColumn>
									<ea:GridColumn DataMember="Value" Caption="B"></ea:GridColumn>
								</Columns>
							</ea:Grid>
							<cc1:ReportFooter id="ReportFooter1" runat="server" WithSections="False" TheEnd="False" CollapseSubtitlesBorder="True"
								Height="112px">
								<Subtitles>
									<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis" Width="15"></cc1:FooterSubtitle>
									<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis" Width="15"></cc1:FooterSubtitle>
									<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis" Width="15"></cc1:FooterSubtitle>
									<cc1:FooterSubtitle Caption="Raport" ID="raport" SubtitleType="CenterText"></cc1:FooterSubtitle>
									<cc1:FooterSubtitle Caption="Kwotę powyższą otrzymałem" SubtitleType="Podpis"></cc1:FooterSubtitle>
								</Subtitles>
							</cc1:ReportFooter><BR>
							<BR>
						</TD>
					</TR>
				</TABLE>
				<ea:SectionMarker id="SectionMarker6" runat="server" SectionType="Footer"></ea:SectionMarker>
			</ea:section></form>
	</body>
</HTML>

